var samplePageObj = {
  // 샘플 타이틀
  title: '라디오 그룹',
  subtitle: '일부 컬럼의 Radio를 그룹으로 묶어서 입력하게 합니다.',

  // 샘플 설명
  desc: '한 행 안에 Radio 타입의 컬럼들을 그룹으로 묶어 하나의 값만 선택되도록 사용하는 샘플입니다.<br>메뉴얼에서 Radio(col)속성을 참고하세요.',

  // 객체 초기화 구문
  init: {
    Def: {
      Header: {},
      Col: { Spanned: 1 },
      Spacer: {
        CanFocus: 0,
        Width: 5
      },
      Row: { CanFormula: 1 }
    },
    Cfg: {
      SearchMode: 0,
      MaxPages: 3,
      SuppressMessage: 3
    },
    LeftCols: [
      {
        Header: 'No',
        Type: 'Int',
        Width: 40,
        Align: 'Center',
        Name: 'SEQ'
      },
    ],
    Cols: [
      {
        Header: '내용',
        Type: 'Text',
        Name: 'Contents',
        RelWidth: 1,
        MinWidth: 250,
        Align: 'Left',
        CanEdit: 0,
        RawSort: 1,
        FormulaRow: '선택된 항목'
      },
      {
        Header: '그렇지\n않다',
        Type: 'Radio',
        Name: 'A1',
        Radio: 1,
        Width: '60',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        FormulaRow: 'countif(\'==1\')'
      },
      {
        Header: '그저\n그렇다',
        Type: 'Radio',
        Name: 'A2',
        Radio: 1,
        Width: '60',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        FormulaRow: 'countif(\'==1\')'
      },
      {
        Header: '그렇다',
        Type: 'Radio',
        Name: 'A3',
        Radio: 1,
        Width: '60',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        FormulaRow: 'countif(\'==1\')'
      },
      {
        Header: '매우\n그렇다',
        Type: 'Radio',
        Name: 'A4',
        Radio: 1,
        Width: '60',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        FormulaRow: 'countif(\'==1\')'
      },
      {
        Header: '내용',
        Type: 'Text',
        Name: 'Contents2',
        RelWidth: 1,
        MinWidth: 250,
        Align: 'Left',
        CanEdit: 0,
        RawSort: 1,
        FormulaRow: '선택된 항목'
      },
      {
        Header: '그렇지\n않다',
        Type: 'Radio',
        Name: 'B1',
        Radio: 2,
        Width: '60',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        FormulaRow: 'countif(\'==1\')'
      },
      {
        Header: '그저\n그렇다',
        Type: 'Radio',
        Name: 'B2',
        Radio: 2,
        Width: '60',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        FormulaRow: 'countif(\'==1\')'
      },
      {
        Header: '그렇다',
        Type: 'Radio',
        Name: 'B3',
        Radio: 2,
        Width: '60',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        FormulaRow: 'countif(\'==1\')'
      },
      {
        Header: '매우\n그렇다',
        Type: 'Radio',
        Name: 'B4',
        Radio: 2,
        Width: '60',
        Align: 'Center',
        CanEdit: 1,
        RawSort: 1,
        FormulaRow: 'countif(\'==1\')'
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><button onclick=\'sampleBtn(this)\'>결과 확인</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    // FomulaRow에서 체크된 항목 가져오기
    var fr = sheet.getRowById('FormulaRow');
    var cntAnswer = 0;
    // 점수배열 선언
    var arrScore = [];
    // 선택된 항목
    var arrCols = [
      'A1',
      'A2',
      'A3',
      'A4',
      'B1',
      'B2',
      'B3',
      'B4'
    ];

    // 선택된 항목들 갯수 계산
    for (var i = 0, len = arrCols.length; i < len; i++) {
      var value = sheet.getValue(fr, arrCols[i]);
      // Radio 그룹 중 같은 배점을 가진 항목들을 정리
      var group = i % (len / 2);

      cntAnswer += value;
      if (arrScore[group] == null) { arrScore[group] = 0; }
      arrScore[group] += value; // "그렇지 않다.", "그저 그렇다.", "그렇다.", "매우 그렇다." 각 답변 체크된 갯수 확인
    }
    // 선택된 항목들 점수 계산
    var rs = 0;

    for (var i = 0; i < arrScore.length; i++) {
      rs += arrScore[i] * i;
    }
    // 모든 항목 체크 확인 및 결과표시
    if (cntAnswer == 15) {
      var dlg = {
        Head: '결과',
        Body: '',
        Modal: 1,
        CloseClick: 1,
        MinHeight: 150
      };

      // 점수별 결과
      if (rs <= 10) {
        dlg.Body = '<div style=\'padding: 5px; width:250px;\'><span style=\'color:black;font-size: 15px;\'>0~10점 : </span><hr/> <span style=\'color:black;font-size: 15px;\'>현재 우울하지 않은 상태입니다.</span></div>';
      } else if (rs <= 20) {
        dlg.Body = '<div style=\'padding: 5px; width:250px;\'><span style=\'color:black;font-size: 15px;\'>11~20점 : </span><hr/> <span style=\'color:black;font-size: 15px;\'>가벼운 우울상태에 있습니다. 기분전환을 위한 노력이 필요합니다.</span></div>';
      } else if (rs <= 30) {
        dlg.Body = '<div style=\'padding: 5px; width:250px;\'><span style=\'color:black;font-size: 15px;\'>21~30점 : </span><hr/> <span style=\'color:black;font-size: 15px;\'>무시하기 힘든 상당한 우울 상태 입니다. 우울을 극복하기 위한 적극적인 노력이 필요하며 이런 상태가 2개월 이상 지속될시 전문가의 도움을 구하십시오.</span></div>';
      } else {
        dlg.Body = '<div style=\'padding: 5px; width:250px;\'><span style=\'color:black;font-size: 15px;\'>31~45점 : </span><hr/> <span style=\'color:black;font-size: 15px;\'>심한 우울 상태 입니다. 가능한 한 빨리 전문가의 도움을 받으십시오.</span></div>';
      }
      IBSheet.showDialog(
        dlg,
        {
          Align: 'center,middle',
          Width: document.body.clientWidth,
          Height: document.body.clientHeight
        }
      );
    } else {
      alert('모든 항목을 체크해주세요.');
    }
  },

  // event구문
  event: {
    onDataLoad: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      // 문항이 홀수이므로 마지막 행 Contents2 영역은 병합
      var row = sheet.getLastRow();

      sheet.setMergeRange(row, 'Contents2', row, 'B4');
    }
  },

  // data
  data: [
    {
      Contents: 'ㆍ나는 기분이 슬프고 울적하다.',
      Contents2: 'ㆍ어떤 일에 나 자신을 억지로 내몰지 않으면 일을 하기가 힘들다.'
    },
    {
      Contents: 'ㆍ나의 미래는 희망이 없다고 느껴진다.',
      Contents2: 'ㆍ나의 외모는 허접하다고 생각된다.'
    },
    {
      Contents: 'ㆍ나 자신이 무가치한 실패자라고 생각된다.',
      Contents2: 'ㆍ식욕이 없다. 또는 지나치게 많이 먹는다.'
    },
    {
      Contents: 'ㆍ나는 다른 사람에 비해 열등하고 나에게 무언가 문제가 있다고 느껴진다.',
      Contents2: 'ㆍ불면으로 고생하고 잠을 자도 개운하게 못 잔다. 또는 이유 없이 피곤해서 너무 많이 잔다.'
    },
    {
      Contents: 'ㆍ나는 거의 모든 일에 나 자신을 비판하고 자책한다.',
      Contents2: 'ㆍ성(sex)에 대한 관심을 잃었다.'
    },
    {
      Contents: 'ㆍ어떤 일을 판단하고 결정하기가 힘들다.',
      Contents2: 'ㆍ나의 건강에 대한 걱정을 많이 하게 된다.'
    },
    {
      Contents: 'ㆍ쉽게 화가 나고 짜증이 난다.',
      Contents2: 'ㆍ인생은 살 만한 가치가 없는 것이며 어쩌면 차라리 죽는 게 나을지도 모른다는 생각이 든다.'
    },
    {
      Contents: 'ㆍ진로, 취미, 가족, 친구에 대한 관심이 사라졌다.',
      Contents2CanFocus: 0
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
